IF EXISTS (SELECT 1 FROM SYS.VIEWS WHERE NAME = 'V_EST_PROD_EST_ARV_MERCADOLOGICA')
    BEGIN 
	   DROP VIEW V_EST_PROD_EST_ARV_MERCADOLOGICA;
    END
GO


DECLARE @FLAG_NOVO_MODELO_PARAMETROS INT, @SqlView as varchar(max);

SET @FLAG_NOVO_MODELO_PARAMETROS = ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG
											 WHERE  CD_EMP = 1 AND CD_CHAVE = 'FLAG_USA_NOVO_MODELO_PARAMETROS'), 0);
		  
if @FLAG_NOVO_MODELO_PARAMETROS =  0
begin
	Set @SqlView = 'CREATE VIEW [dbo].[V_EST_PROD_EST_ARV_MERCADOLOGICA]
						AS
						SELECT     
							CP.CD_EMP, 
							M.CD_GRP_PARAM, 
							CP.CD_FILIAL, 
							CP.CD_PROD, 
							M.P1, 
							M.P2, 
							M.P1_SAZ, 
							M.P2_SAZ, 
							M.PPV,
							M.EMAX, 
							M.ESEG,	
							M.CD_SIGLA, 
							M.CD_ARV_MERC_LINHA, 
							M.FREAV_MEDIAF, 
							M.FREAV_MEDIAF_ULT_ATU, 
							M.DS_GRP_PARAM,	
							M.DT_ULT_ALT, 
							M.PROXIMO_RECALC,
							cp.STS_PROD,
							mf.QTDE_MEDIA MEDIAF,
							cp.EMAX AS EMAX_PROD,
							cp.QT_EST,
							mf.QTDE_LIMITADOR,
							mf.QTDE_FINANCIADO,
							mf.QTDE_FACEAMENTO,
							M.TP_GRUPO_PARAMETRO 
						FROM         
							dbo.V_EST_ARV_MD_F_GRP_PARAM_PRC_FILIAL M
							INNER JOIN dbo.V_EST_PROD_EST_ARV_MERCADOLOGICA_CURVA_FILIAL C ON 
							M.CD_EMP			= C.CD_EMP AND 
							M.CD_FILIAL			= C.CD_FILIAL AND 
							M.CD_SIGLA			= C.CD_SGL_ATU AND 
							M.CD_ARV_MERC_LINHA = C.CD_ARV_MERC_LINHA

							INNER JOIN  V_EST_PROD_CPL_MEDIAF_MEDIAP mf ON
							c.CD_EMP	= MF.CD_EMP AND
							c.CD_FILIAL = MF.CD_FILIAL AND
							c.CD_PROD	= MF.CD_PROD

							INNER JOIN EST_PROD_CPL cp ON
							C.CD_EMP = cp.CD_EMP AND
							C.CD_FILIAL = cp.CD_FILIAL AND
							C.CD_PROD = cp.CD_PROD
						WHERE
							CP.CD_EMP=1 '
end

if @FLAG_NOVO_MODELO_PARAMETROS =  1
begin
	Set @SqlView = 'CREATE VIEW [dbo].[V_EST_PROD_EST_ARV_MERCADOLOGICA]
					AS
					SELECT
							p.CD_EMP
							, f.CD_CTR CD_GRP_PARAM
							, p.CD_FILIAL          
							, P.CD_PROD
							, grp.P1
							, grp.P2
							, grp.P1_SAZ
							, grp.P2_SAZ
							, 0 PPV
							, grp.EMAX
							, grp.ESEG
							, grp.CD_SIGLA
							, ARV.CD_ARV_MERC_LINHA	 
							, GRP.FREVISAOMEDIAF FREAV_MEDIAF
							, P.FRQ_MEDIAF_ULT_ATU FREAV_MEDIAF_ULT_ATU
							, S.DS_GRUPO_CURVA DS_GRP_PARAM     
							, GRP.DT_ULT_ALT DT_ULT_ALT
							, CONVERT(DATE, ISNULL(DATEADD(DAY, GRP.FREVISAOMEDIAF, P.FRQ_MEDIAF_ULT_ATU), GETDATE())) PROXIMO_RECALC
							, cp.STS_PROD
							, mf.QTDE_MEDIA MEDIAF
							, cp.EMAX AS EMAX_PROD
							, cp.QT_EST
							, mf.QTDE_LIMITADOR
							, mf.QTDE_FINANCIADO
							, mf.QTDE_FACEAMENTO
							, 1 TP_GRUPO_PARAMETRO 	 
					FROM
							EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD P	 
							JOIN EST_PROD_EST_ARV_MERCADOLOGICA ARV ON 	 										
																P.CD_EMP	= ARV.CD_EMP
															AND P.CD_PROD   = ARV.CD_PROD 
							JOIN EST_PROD_CPL cp ON 
	 															P.CD_FILIAL = cp.CD_FILIAL
															AND P.CD_EMP	= cp.CD_EMP
															AND P.CD_PROD   = cp.CD_PROD 
															AND P.CD_SIGLA  = cp.CD_SIGLA

							INNER JOIN  V_EST_PROD_CPL_MEDIAF_MEDIAP mf ON
							CP.CD_EMP		= MF.CD_EMP AND
							CP.CD_FILIAL	= MF.CD_FILIAL AND
							CP.CD_PROD		= MF.CD_PROD


							JOIN EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL F ON 
																P.CD_FILIAL = f.CD_FILIAL
															AND P.CD_EMP	= f.CD_EMP		 
							JOIN EST_PARAM_COMPRAS_GRUPO_CURVA AS S	ON P.CD_GRUPO_CURVA = S.CD_GRUPO_CURVA
							JOIN EST_PARAM_COMPRAS_GRUPO_CURVA_EST_PROD_CURVA_SIGLA GRP ON		P.CD_GRUPO_CURVA = GRP.CD_GRUPO_CURVA
																						AND P.CD_SIGLA		 = GRP.CD_SIGLA 
					where
						cp.cd_emp=1'
end

exec (@SqlView)
GO


